#ifndef CE2_RSA_PRIM_H
#define CE2_RSA_PRIM_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 *  Object %CE2_RSA_PRIM.h    : %
 *  State           :  %state%
 *  Creation date   :  %date%
 *  Last modified   :  %modify_time%
 */
/** @file
 *  \brief This module defines the API that supports PKCS#1 v2.1 primitive functions
 *
 *  \version CE2_HASH.h#1:incl:1
 *  \author ronys
 *  \remarks Copyright (C) 2001-2005 by Discretix Technologies Ltd. All Rights reserved.
 */

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Encrypt
*
* Inputs:
*  @param UserPubKey_ptr [in] - A pointer to the public key data structure;
*  @param Data_ptr   [in] - A pointer to the data to encrypt;
*  @param DataSize   [in] - The size, in bytes, of the data to encrypt;
*         \note This value must be <= the size of the modulus.
*  @param Output_ptr [out] - Pointer to the encrypted data.
*         The buffer must be at least PubKey_ptr->N.len bytes long 
*         (that is, the size of the modulus, in bytes).
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PUB_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_BUFFER_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Encrypt implements the RSAEP algorithm
*  as defined in PKCS#1 v2.1 6.1.1
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_PRIM_Encrypt
*     to encrypt data using public key with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_PRIM_Encrypt(CE2_RSAUserPubKey_t *UserPubKey_ptr,
                                  DxUint8_t              *Data_ptr,
                                  DxUint16_t              DataSize,
                                  DxUint8_t              *Output_ptr);

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Decrypt
*
* Inputs:
*  @param UserPrivKey_ptr [in] - Pointer to the private key data structure;
*         \note The representation (pair or quintuple) 
*         and hence the algorithm (CRT or not-CRT) 
*         is determined by the Private Key data structure - 
*         using CE2_Build_PrivKey or CE2_Build_PrivKeyCRT 
*         determines which algorithm will be used.
*  @param Data_ptr   [in] - A pointer to the data to be decrypted;
*  @param DataSize   [in] - The size, in bytes, of the data to decrypt;
*         \note Must be <= the size of the modulus.
*  @param Output_ptr [out] - A pointer to the decrypted data.
*         The buffer must be at least PrivKey_ptr->N.len bytes long 
*         (that is, the size of the modulus, in bytes).
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_PRIV_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Decrypt implements the RSADP algorithm as
*  defined in PKCS#1 v2.1 6.1.2
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_PRIM_Decrypt
*     to decrypt data using private key  with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_PRIM_Decrypt(CE2_RSAUserPrivKey_t *UserPrivKey_ptr,
                                  DxUint8_t     *Data_ptr,
                                  DxUint16_t     DataSize,
                                  DxUint8_t     *Output_ptr);

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Sign
*
* Inputs:
*  see CE2_RSA_PRIM_Decrypt.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Sign implements the RSASP1 algorithm
*  as defined in PKCS#1 v2.1 6.2.1
*  \def CE2_RSA_PRIM_Sign The signature primitive is identical
*  to the decryption algorithm
*
* \b
* Algorithm:
*  -# call CE2_RSA_PRIM_Decrypt.
***************************************************************/
#define CE2_RSA_PRIM_Sign CE2_RSA_PRIM_Decrypt

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Verify
*
* Inputs:
*  see CE2_RSA_PRIM_Decrypt.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Verify implements the RSAVP1 algorithm
*  as defined in PKCS#1 v2.1 6.2.2
*  \def CE2_RSA_PRIM_Verify The verification primitive is identical
*  to the encryption algorithm
*
* \b
* Algorithm:
*  -# call CE2_RSA_PRIM_Encrypt.
***************************************************************/
#define CE2_RSA_PRIM_Verify CE2_RSA_PRIM_Encrypt

#ifdef __cplusplus
}
#endif

#endif /* CE2_RSA_PRIM_H */
